LOCAL_PATH:= $(call my-dir)

# We need to build this for both the device (as a shared library)
# and the host (as a static library for tools to use).

common_SRC_FILES := \
	png.c \
	pngerror.c \
	pngget.c \
	pngmem.c \
	pngpread.c \
	pngread.c \
	pngrio.c \
	pngrtran.c \
	pngrutil.c \
	pngset.c \
	pngtrans.c \
	pngwio.c \
	pngwrite.c \
	pngwtran.c \
	pngwutil.c \

ifeq ($(ARCH_ARM_HAVE_NEON),true)
my_cflags_arm := -DPNG_ARM_NEON_OPT=2
endif

my_cflags_arm64 := -DPNG_ARM_NEON_OPT=2

my_src_files_arm := \
			arm/arm_init.c \
			arm/filter_neon.S \
			arm/filter_neon_intrinsics.c \
			arm/palette_neon_intrinsics.c


# -std=gnu89 is not allowed from Android NDK build
#common_CFLAGS := -std=gnu89 #-fvisibility=hidden ## -fomit-frame-pointer

ifeq ($(TARGET_ARCH_ABI), armeabi-v7a)
common_SRC_FILES += $(my_src_files_arm)
endif
ifeq ($(TARGET_ARCH_ABI), arm64-v8a)
common_SRC_FILES += $(my_src_files_arm)
endif

# For the host
# =====================================================

#include $(CLEAR_VARS)
#LOCAL_SRC_FILES := $(common_SRC_FILES)
#LOCAL_CFLAGS += $(common_CFLAGS)
#LOCAL_ASFLAGS += $(common_ASFLAGS)
#LOCAL_EXPORT_C_INCLUDE_DIRS := $(LOCAL_PATH)
#LOCAL_STATIC_LIBRARIES := libz
#LOCAL_MODULE:= libpng
#include $(BUILD_HOST_STATIC_LIBRARY)


# For the device (static)
# =====================================================

#include $(CLEAR_VARS)
#LOCAL_CLANG := true
#LOCAL_SRC_FILES := $(common_SRC_FILES)
#LOCAL_CFLAGS += $(common_CFLAGS) -ftrapv
#LOCAL_CFLAGS_arm := $(my_cflags_arm)
#LOCAL_ASFLAGS += $(common_ASFLAGS)
#LOCAL_SRC_FILES_arm := $(my_src_files_arm)
#LOCAL_CFLAGS_arm64 := $(my_cflags_arm64)
#LOCAL_SRC_FILES_arm64 := $(my_src_files_arm)
#LOCAL_SANITIZE := never
#LOCAL_EXPORT_C_INCLUDE_DIRS := $(LOCAL_PATH)
#LOCAL_SHARED_LIBRARIES := libz
#LOCAL_MODULE:= libpng
#include $(BUILD_STATIC_LIBRARY)

# For the device (shared)
# =====================================================

include $(CLEAR_VARS)
LOCAL_CLANG := true
LOCAL_SRC_FILES := $(common_SRC_FILES)
LOCAL_CFLAGS += $(common_CFLAGS) -ftrapv
LOCAL_CFLAGS_arm := $(my_cflags_arm)
LOCAL_ASFLAGS += $(common_ASFLAGS)
LOCAL_SRC_FILES_arm := $(my_src_files_arm)
LOCAL_CFLAGS_arm64 := $(my_cflags_arm64)
LOCAL_SRC_FILES_arm64 := $(my_src_files_arm)
#LOCAL_EXPORT_C_INCLUDE_DIRS := $(LOCAL_PATH)
#LOCAL_SHARED_LIBRARIES := libz
#LOCAL_MODULE:= libpng
LOCAL_EXPORT_C_INCLUDES := $(LOCAL_PATH)
LOCAL_LDLIBS += -lz
LOCAL_MODULE:= tuxpaint_png
include $(BUILD_SHARED_LIBRARY)

# For testing
# =====================================================

#include $(CLEAR_VARS)
#LOCAL_CLANG := true
#LOCAL_SRC_FILES:= pngtest.c
#LOCAL_MODULE := pngtest
#LOCAL_SHARED_LIBRARIES:= libpng libz
#LOCAL_MODULE_TAGS := debug
#include $(BUILD_EXECUTABLE)
